( function () {
	const root = document.createElement( 'div' );
	root.id = 'hw-reader-root';
	document.body.insertBefore( root, document.body.firstChild );

	// OAI-260103: Lightweight bar only; no placeholder body content.
	const stored = window.localStorage.getItem( 'hubw_user' );
	let currentUser = stored ? JSON.parse( stored ) : null;

    root.innerHTML = `
        <div style="position:sticky;top:0;z-index:9999;background:#0f172a;color:#f8fafc;padding:10px 16px;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,sans-serif;display:flex;gap:16px;align-items:center;justify-content:space-between;">
			<div style="display:flex;gap:14px;align-items:center;">
				<a href="https://wordierpress.com" style="color:#f8fafc;text-decoration:none;font-weight:600;">WordierPress</a>
				<a href="https://wordierpress.com/hubwright" style="color:#cbd5e1;text-decoration:none;">hubWright</a>
				<a href="https://wordierpress.com/authors" style="color:#cbd5e1;text-decoration:none;">Authors</a>
				<a href="https://wordierpress.com/reader" style="color:#cbd5e1;text-decoration:none;">Reader</a>
				<a href="https://wordierpress.com/tags" style="color:#cbd5e1;text-decoration:none;">Tags</a>
				<a href="https://wordierpress.com/topics" style="color:#cbd5e1;text-decoration:none;">Topics</a>
				<a href="https://wordierpress.com/trending" style="color:#cbd5e1;text-decoration:none;">Trending</a>
			</div>
			<div id="hw-user-area" style="display:flex;align-items:center;gap:12px;">
				<a id="hw-login-toggle" href="#" style="color:#cbd5e1;text-decoration:none;">Login</a>
				<span style="display:inline-block;width:24px;"></span>
				<a href="https://wordierpress.com/hubwright" style="color:#cbd5e1;text-decoration:none;">WordPress Plugin</a>
			</div>
        </div>
		<div id="hw-login-panel" style="display:none;background:#0b1224;color:#e2e8f0;padding:14px 16px;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,sans-serif;border-bottom:1px solid #1f2937;">
			<div style="display:flex;flex-wrap:wrap;gap:16px;align-items:flex-start;">
				<div style="min-width:240px;max-width:300px;">
					<form id="hw-login-form">
						<label style="display:block;margin-bottom:6px;font-weight:600;">Email</label>
						<input type="email" name="email" required style="width:100%;padding:8px;border:1px solid #334155;border-radius:4px;background:#0f172a;color:#e2e8f0;margin-bottom:10px;" />
						<label style="display:block;margin-bottom:6px;font-weight:600;">Password</label>
						<input type="password" name="password" required style="width:100%;padding:8px;border:1px solid #334155;border-radius:4px;background:#0f172a;color:#e2e8f0;margin-bottom:12px;" />
						<button type="submit" style="background:#22c55e;border:0;color:#0b1224;font-weight:700;padding:8px 12px;border-radius:4px;cursor:pointer;">Sign in</button>
						<a href="https://wordierpress.com/register" style="margin-left:10px;color:#93c5fd;text-decoration:underline;">Register</a>
					</form>
				</div>
				<div style="flex:1;min-width:220px;max-width:420px;">
					<p style="margin:0 0 6px 0;"><strong>United We Blog - WordierPress</strong></p>
					<p style="margin:0 0 10px 0;">Indie voices.&nbsp;Share.&nbsp;Discover.&nbsp;Kindred authorship.&nbsp;Copyright protection.</p>
					<p style="margin:0 0 8px 0;"><strong>What is WordierPress?</strong> A community of content creators connected through the hub for discovery, sharing, and collaboration.</p>
					<p style="margin:0;"><strong>What is hubWright?</strong> The WordPress tool that links your site to WordierPress—sync posts, gate content, stamp authorship, migrate from other platforms, and keep your readers connected.</p>
				</div>
			</div>
		</div>
    `;

	const userArea = root.querySelector( '#hw-user-area' );
	const loginToggle = root.querySelector( '#hw-login-toggle' );
	const loginPanel = root.querySelector( '#hw-login-panel' );
	const loginForm = root.querySelector( '#hw-login-form' );

	function renderUser() {
		if ( ! userArea ) {
			return;
		}
		if ( currentUser && currentUser.email ) {
			userArea.innerHTML = `
				<a href="https://wordierpress.com/user/${ currentUser.id || 'me' }" style="color:#cbd5e1;text-decoration:none;font-weight:600;">
					${ currentUser.email }
				</a>
				<a href="#" id="hw-logout" style="color:#cbd5e1;text-decoration:none;">Logout</a>
			`;
			const logout = userArea.querySelector( '#hw-logout' );
			logout.addEventListener( 'click', function ( e ) {
				e.preventDefault();
				currentUser = null;
				window.localStorage.removeItem( 'hubw_user' );
				userArea.innerHTML = '';
				userArea.appendChild( loginToggle );
				loginPanel.style.display = 'none';
			} );
		} else {
			userArea.innerHTML = '';
			userArea.appendChild( loginToggle );
		}
	}

	if ( loginToggle && loginPanel ) {
		loginToggle.addEventListener( 'click', function ( e ) {
			e.preventDefault();
			const visible = loginPanel.style.display === 'block';
			loginPanel.style.display = visible ? 'none' : 'block';
		} );
	}

	if ( loginForm ) {
		loginForm.addEventListener( 'submit', function ( e ) {
			e.preventDefault();
			const email = loginForm.querySelector( 'input[name="email"]' ).value.trim();
			if ( ! email ) {
				return;
			}
			// OAI-260104: placeholder client-side login; real auth delegates to wordierpress.com.
			currentUser = {
				email,
				id: email.replace( /[^a-zA-Z0-9]/g, '' ).toLowerCase() || 'me',
			};
			window.localStorage.setItem( 'hubw_user', JSON.stringify( currentUser ) );
			loginPanel.style.display = 'none';
			renderUser();
			window.location.href = 'https://wordierpress.com/my';
		} );
	}

	renderUser();
} )();
